const notification = require('../../../notification');

/**
 * Utilizes initialization of the Clipboard.js functionality.
 *
 * @mixin
 */
const ClipboardClientMixin = {
    initializeClipboardClient(copyTrigger, copyMessage) {
        if (copyTrigger) {
            const self = this;

            self.clipboardClient = new Clipboard(copyTrigger);
            self.clipboardClient.on('success', () => {
                if (copyMessage) {
                    notification.message(copyMessage, {
                        reload: false
                    });
                }
            });
        }
    }
};

module.exports = ClipboardClientMixin;
