/**
 * @class NotificationMessage
 * @extends Backbone.Marionette.ItemView
 *
 * @property {Backbone.Model} model
 */
const NotificationMessage = Marionette.ItemView.extend({

    template: require('./tpl/NotificationMessage.hbs'),
    className: 'global-message',

    ui: {
        timerAnimationCnt: '.timer__r'
    },

    events: {
        'click .close': 'onCloseEvent',
        'click .reload': 'onReload'
    },

    options: {
        animated: true,
        autoClose: true,
        autoClosePeriod: 5000
    },

    initialize(options) {
        this.options = _.extend({}, this.options, options);

        if (this.options.autoClose) {
            const self = this;

            setTimeout(() => {
                if (self.options.animated) {
                    self.$el.animate(
                        {
                            top: ('-=' + self.$el.outerHeight())
                        },
                        {
                            always() {
                                self.close();
                            }
                        }
                    );
                } else {
                    self.close();
                }
            }, this.options.autoClosePeriod);
        }

        if (this.options.style) {
            this.$el.css(this.options.style);
        }
    },

    onCloseEvent(e) {
        e.preventDefault();
        this.close();
    },

    onReload(e) {
        e.preventDefault();
        window.location.reload();
    },

    serializeData() {
        const serialized = _.defaults(this.options, {
            reload: true,
            close: true
        });

        serialized.autoClosePeriod /= 1000;

        return serialized;
    }
});

module.exports = NotificationMessage;
