const cookie = require('bemmy/src/blocks/component/cookie');
const app = require('../../../app');
const GridLayout = Marionette.Layout.extend({

    template: require('./tpl/grid.hbs'),

    className: 'section__data',

    collectionEvents: {
        sync: 'render'
    },

    options: {
        gridClass: null,
        gridOptions: {},
        paginationClass: require('../../pagination/PaginationLayout')
    },

    /** REGIONS DEFINED DIRECTLY IN THE TEMPLATE */

    initialize(options) {
        this.options = _.extend({}, this.options, options);

        this.checkData();
        this.checkViews();
    },

    onRender() {
        this.grid.close();
        this.grid.show(this.getGrid());

        if (this.options.paginationClass) {
            this.pagination.close();
            this.pagination.show(this.getPagination());
        }

        app.performance.content = (Math.round(window.performance.now() - app.performance.epoch)) / 1000;

        if (window.yaCounter28049724 && window.yaCounter28049724.reachGoal && window.location.host === 'sandbox.yandex-team.ru') {
            const params = {
                login: cookie.getYandexLogin(),
                internalRoute: app.performance.internalRoute,
                time: app.performance.content,
                origin: document.location.pathname + document.location.search
            };

            window.yaCounter28049724.reachGoal('PERFORMANCE_CONTENT', params);
        }
    },

    getGrid() {
        const GridClass = this.options.gridClass;

        return new GridClass(_.extend(
            {},
            { collection: this.collection },
            this.options.gridOptions
        ));
    },

    getPagination() {
        const PaginationClass = this.options.paginationClass;

        return new PaginationClass({
            gridCnt: this.$el,
            collection: this.collection
        });
    },

    checkData() {
        if (!this.collection) {
            throw new Error('Collection is not defined. GridLayout can not be created.');
        }
    },

    checkViews() {
        if (!this.options.gridClass) {
            throw new Error('GridClass is not defied. GridLayout can not be created.');
        }
    },

    serializeData() {
        return {
            paging: Boolean(this.options.paginationClass)
        };
    }
});

module.exports = GridLayout;
