/**
 * Utilizes functionality that will scroll page to the top of the grid on page or capacity switch.
 *
 * @mixin PaginationGridScrollerMixin
 */
const PaginationGridScrollerMixin = {

    makeGridCntVisible() {
        if (!this.options.gridCnt) {
            return;
        }

        const body = $('body');
        const cntOffset = (this.options.gridCnt ? this.options.gridCnt.offset() : { top: 0 });

        if (body.scrollTop() > cntOffset.top) {
            body.animate({
                scrollTop: cntOffset.top - 30 // 30 is here to scroll a little bit upper then table border
            }, 300);
        }
    }
};

module.exports = PaginationGridScrollerMixin;
