const app = require('../../../app');

const ApiInfoPanel = Marionette.ItemView.extend({

    model: new Backbone.Model({
        node: '',
        revision: ''
    }),

    modelEvents: {
        change: 'render'
    },

    template: require('./tpl/apiInfoPanel.hbs'),

    className: 'api_info',

    initialize() {
        const self = this;

        this.listenTo(app.vent, 'API_INFO_CHANGED', (node, revision) => {
            self.updateApiInfo(node, revision);
        });
    },

    updateApiInfo(node, revision) {
        this.model.set({
            node,
            revision,
            uiVersion: window.uiVersion
        });
    }
});

module.exports = ApiInfoPanel;
