const app = require('../../../app');

const SandboxModeInfoPanel = Marionette.ItemView.extend({

    model: new Backbone.Model({
        mode: 'NORMAL',
        targetName: ''
    }),

    modelEvents: {
        change: 'render'
    },

    template: require('./tpl/sandboxModeInfoPanel.hbs'),

    className: 'alert alert_size_L alert_type_crit',

    initialize() {
        const self = this;

        this.listenTo(app.vent, 'API_MODE_CHANGED', (mode, targetSrvName) => {
            self.updateMode(String(mode).toUpperCase(), targetSrvName);
        });
    },

    updateMode(mode, targetSrvName) {
        this.model.set({
            mode,
            targetName: targetSrvName
        });
    }
});

module.exports = SandboxModeInfoPanel;
