const app = require('../../../app');
const StatusPanel = require('../../../model/StatusPanel');
// eslint-disable-next-line no-unused-vars
const TaskModel = require('../../../model/TaskModel');

/**
 * @class TaskStatusCounterPanel
 * @extends Backbone.Marionette.ItemView
 *
 * @property {StatusPanel} model
 */
const TaskStatusCounterPanel = Marionette.ItemView.extend({

    className: 'section__tab',
    template: require('./tpl/TaskStatusCounterPanel.hbs'),

    initialize() {
        this.fetchStatistics = this.fetchStatistics.bind(this);
        this.absolute = new StatusPanel();
        this.delta = new StatusPanel({ delta: true });

        this.on('stat_fetched', this.render);

        this.fetchStatistics();
        this.activateAutoupdate();
    },

    fetchStatistics() {
        if (!app.reqres.request('AUTOUPDATE_SKIP')) {
            app.reqres.request('AUTOUPDATE_SKIP', true);

            const self = this;

            return $.when(this.absolute.fetch({ reset: true }), this.delta.fetch({ reset: true })).done(() => {
                app.reqres.request('AUTOUPDATE_SKIP', false);
                self.trigger('stat_fetched');
            });
        }
    },

    activateAutoupdate() {
        this.autoupdateInterval = setInterval(this.fetchStatistics, 5000);
    },

    serializeData() {
        /* eslint dot-notation: 0 */

        if (!this.absolute.get('execute')) {
            return {};
        }

        return {
            tasks: [
                {
                    qnt: this.absolute.get('execute')['executing'],
                    delta: this.delta.get('execute')['executing'],
                    status: 'executing'
                },
                {
                    qnt: this.absolute.get('execute')['temporary'],
                    delta: this.delta.get('execute')['temporary'],
                    status: 'temporary'
                },
                {
                    qnt: this.absolute.get('queue')['enqueuing'],
                    delta: this.delta.get('queue')['enqueuing'],
                    status: 'enqueuing'
                },
                {
                    qnt: this.absolute.get('queue')['enqueued'],
                    delta: this.delta.get('queue')['enqueued'],
                    status: 'enqueued'
                },
                {
                    qnt: this.absolute.get('wait')['wait_res'],
                    delta: this.delta.get('wait')['wait_res'],
                    status: 'wait_res'
                },
                {
                    qnt: this.absolute.get('wait')['wait_task'],
                    delta: this.delta.get('wait')['wait_task'],
                    status: 'wait_task'
                },
                {
                    qnt: this.absolute.get('wait')['wait_time'],
                    delta: this.delta.get('wait')['wait_time'],
                    status: 'wait_time'
                },
                {
                    qnt: this.absolute.get('break')['no_res'],
                    delta: this.delta.get('break')['no_res'],
                    status: 'no_res'
                },
                {
                    qnt: this.absolute.get('break')['exception'],
                    delta: this.delta.get('break')['exception'],
                    status: 'exception'
                },
                {
                    qnt: this.absolute.get('break')['timeout'],
                    delta: this.delta.get('break')['timeout'],
                    status: 'timeout'
                }
            ]
        };
    },

    onClose() {
        this.stopListening(this, 'stat_fetched');
        app.reqres.request('AUTOUPDATE_SKIP', false);
        clearInterval(this.autoupdateInterval);
    }
});

module.exports = TaskStatusCounterPanel;
