const PopupMenuView = require('../PopupMenuView');

/**
 * @class TimeLineControl
 * @extends PopupMenuView
 */
const TimeLineControl = PopupMenuView.extend({

    className: 'timeline-control',

    template: require('./tpl/timeLineControl.hbs'),

    isActive: false,

    ui: _.extend({}, PopupMenuView.prototype.ui, {
        days: '.day'
    }),

    events: _.extend({}, PopupMenuView.prototype.events, {
        'click @ui.days': 'onDaySelect'
    }),

    options: _.extend({}, PopupMenuView.prototype.options, {
        selectedEventName: 'timeline:selected',
        dayActiveClass: 'cur',
        lineLength: 14
    }),

    initialize() {
        PopupMenuView.prototype.initialize.apply(this, arguments);

        this.currentDate = moment().subtract(1, 'd');
    },

    onDaySelect(evtObj) {
        this.ui.days.removeClass(this.options.dayActiveClass);
        $(evtObj.target).addClass(this.options.dayActiveClass);
        this.$el.trigger(this.options.selectedEventName, evtObj.target.dataset.date);

        this.currentDate = moment(evtObj.target.dataset.date, 'DD.MM.YYYY');
    },

    isCurrent(toCompare) {
        return (
            this.currentDate.date() === toCompare.date() &&
            this.currentDate.month() === toCompare.month() &&
            this.currentDate.year() === toCompare.year()
        );
    },

    serializeData() {
        const date = moment().subtract(this.options.lineLength, 'd');
        const serialized = { months: [] };

        for (let q = 0; q < (this.options.lineLength + 1); q++) {
            if (serialized.months.length &&
                serialized.months[serialized.months.length - 1].title === date.format('MMMM')) {
                serialized.months[serialized.months.length - 1].days.push({
                    label: date.format('D'),
                    date: date.format('DD.MM.YYYY'),
                    cur: this.isCurrent(date)
                });
            } else {
                serialized.months.push({
                    title: date.format('MMMM'),
                    days: [{
                        label: date.format('D'),
                        date: date.format('DD.MM.YYYY'),
                        cur: this.isCurrent(date)
                    }]
                });
            }

            date.add(1, 'd');
        }

        return serialized;
    }
});

module.exports = TimeLineControl;
