const app = require('../../app');

const BatchControlsView = require('./batchControls/BatchControlsView');
const FilterLayout = require('./filter/FilterLayout');
// eslint-disable-next-line no-unused-vars
const resources = require('../../resources');

/**
 * @class ControlSectionLayout
 * @extends Marionette.Layout
 *
 * @property {CoreApplication} model
 * @property {TasksCollection} collection
 */
const ControlSectionLayout = Marionette.Layout.extend({

    className: 'section__ii section__ii_filter app_temp_padding_remover',

    template: require('./tpl/ControlSectionLayout.hbs'),

    options: {
        batchCtrlsToggler: 'section__ii_ctrl'
    },

    collectionEvents: {
        'change:selected': 'onSelectedChanged'
    },

    initialize() {
        this.collection = this.collection || app.getCurrentCollection();

        this.stopListening(app, 'change::collection:selected');
        this.listenTo(app, 'change::collection:selected', this.onSelectedChanged.bind(this));
    },

    /** REGIONS DEFINED DIRECTLY IN TEMPLATE */

    onShow() {
        this.controls.close();
        this.filter.close();
        this.controls.show(this.getBatchControls());
        this.filter.show(this.getFilter());
    },

    onSelectedChanged() {
        if (!this.collection) {
            this.collection = app.getCurrentCollection();
        }

        this.controls.close();
        this.controls.show(this.getBatchControls());

        this.toggleControls();
    },

    getFilter() {
        const currentType = app.getCurrentFilter();
        const defaultFilters = app.getDefaultFilter();

        return new FilterLayout({
            user: this.model.getUser(),
            model: defaultFilters && defaultFilters[currentType] && defaultFilters[currentType].clone(),
            taskProps: this.model.getProps(),
            collection: this.collection
        });
    },

    getBatchControls() {
        return new BatchControlsView({
            collection: this.collection
        });
    },

    toggleControls() {
        this.$el.removeClass(this.options.batchCtrlsToggler);

        if (this.collection && this.collection.getSelected().length > 0) {
            this.$el.addClass(this.options.batchCtrlsToggler);
        }
    },

    onClose() {
        this.stopListening(app, 'change::collection:selected');
    }
});

module.exports = ControlSectionLayout;
