const ActionErrorModalView = require('./singleTask/ActionErrorModalView');

/**
 * @class SingleItemViewControlSectionLayout
 * @extends Marionette.Layout
 *
 * @property {Backbone.Model} model
 */
const SingleItemViewControlSectionLayout = Marionette.Layout.extend({

    ui: {
        descCnt: '.type_description',
        descToggler: '.task_type_description_toggler'
    },

    events: {
        'click @ui.descToggler': 'onDescToggle'
    },

    modelEvents: {
        sync: 'render',
        actionError: 'showActionError',
        'change:release': 'render'
    },

    showActionError(errOpts) {
        (new ActionErrorModalView(errOpts)).show();
    },

    onDescToggle() {
        const self = this;

        if (!this.ui.descCnt.is(':animated')) {
            this.ui.descCnt.slideToggle({
                complete() {
                    self.ui.descToggler.toggleClass('opened');
                }
            });
        }

        return false;
    }
});

module.exports = SingleItemViewControlSectionLayout;
