const UserGroupModel = require('../../../model/resources/UserGroupModel');
const GroupAddModalView = require('../../admin/manageGroups/GroupAddModalView');

/**
 * @class ManageGroupsControls
 * @extends Backbone.Marionette.ItemView
 */
const ManageGroupsControls = Marionette.ItemView.extend({

    className: 'section__nav section__nav_bdb',

    template: require('./tpl/manageGroupsControls.hbs'),

    ui: {
        addItem: '.add_item_trigger'
    },

    events: {
        'click @ui.addItem': 'onAddItem'
    },

    onAddItem() {
        (new GroupAddModalView({
            model: new UserGroupModel({ members: new Backbone.Collection() }),
            collection: this.collection
        })).show();

        return false;
    }
});

module.exports = ManageGroupsControls;
