const SemaphoreModel = require('../../../model/SemaphoreModel');
const SemaphoreAddModalView = require('../../admin/manageSemaphore/SemaphoreAddModalView');
const ManageGroupsControls = require('./ManageGroupsControls');

/**
 * @class ManageSemaphoresControls
 * @extends Backbone.Marionette.ItemView
 */
const ManageSemaphoresControls = ManageGroupsControls.extend({

    className: 'section__nav',

    template: require('./tpl/manageVaultsControls.hbs'),

    onAddItem() {
        (new SemaphoreAddModalView({
            model: new SemaphoreModel({}),
            user: this.model.getUser(),
            taskProps: this.model.getProps(),
            collection: this.collection
        })).show();

        return false;
    }
});

module.exports = ManageSemaphoresControls;

