const VaultModel = require('../../../model/VaultModel');
const VaultAddModalView = require('../../admin/manageVault/VaultAddModalView');
const ManageGroupsControls = require('./ManageGroupsControls');

/**
 * @class ManageVaultsControls
 * @extends Backbone.Marionette.ItemView
 */
const ManageVaultsControls = ManageGroupsControls.extend({

    template: require('./tpl/manageVaultsControls.hbs'),

    onAddItem() {
        (new VaultAddModalView({
            user: this.model.getUser(),
            model: new VaultModel({
                shared: new Backbone.Collection()
            }),
            taskProps: this.model.getProps(),
            collection: this.collection
        })).show();

        return false;
    }
});

module.exports = ManageVaultsControls;
