const BasicConfirmDialogView = require('../../components/BasicConfirmDialogView');

/**
 * @class BatchActionErrorModalView
 * @extends BasicConfirmDialogView
 */
const BatchActionErrorModalView = BasicConfirmDialogView.extend({

    template: require('./tpl/BatchActionErrorModalView.hbs'),

    serializeData() {
        return {
            groups: _.filter(Object.keys(this.options.results).map(function (result) {
                return {
                    type: result,
                    results: this.options.results[result]
                };
            }, this), group => {
                return group.results.length;
            })
        };
    }
});

module.exports = BatchActionErrorModalView;
