const notification = require('../../../notification');
const BasicCollection = require('../../../collection/BasicCollection');
// eslint-disable-next-line no-unused-vars
const BatchActionErrorModalView = require('./BatchActionErrorModalView');
const BulkTaskRemoveConfirmView = require('../../tasks/taskRemoveConfirm/BulkTaskRemoveConfirmView');
const batchErrorMessage = require('./tpl/BatchErrorMessage.hbs');

/**
 * @class BatchControlsView
 * @property {TasksCollection} collection
 */
const BatchControlsView = Marionette.ItemView.extend({

    className: 'section__ii__ctrl',

    template: require('./tpl/BatchControlsView.hbs'),

    ui: {
        buttons: '.button'
    },

    events: {
        'click @ui.buttons': 'onBatchAction'
    },

    options: {
        loadBtnClass: 'button_load'
    },

    initialize() {
        this.listenTo(Backbone, BasicCollection.BATCH_ACTION_RESULT_EVENT, this.onBatchResult);
    },

    onBatchResult(results) {
        if (results.ERROR.length || results.WARNING.length) {
            notification.message(batchErrorMessage({
                groups: _.filter(Object.keys(results).map(result => {
                    return {
                        type: result,
                        results: results[result]
                    };
                }, this), group => {
                    return (group.results.length && group.type !== 'SUCCESS');
                })
            }), {
                reload: false,
                autoClosePeriod: 10000
            });
        }
    },

    onBatchAction(evtObj) {
        const loadBtnClass = this.options.loadBtnClass;

        evtObj.preventDefault();

        if (!evtObj.currentTarget.classList.contains(loadBtnClass)) {
            evtObj.currentTarget.classList.add(loadBtnClass);

            if (evtObj.target.dataset.action === 'delete') {
                (new BulkTaskRemoveConfirmView({
                    collection: this.collection,
                    callback() {
                        evtObj.currentTarget.classList.remove(loadBtnClass);
                    }
                })).show();
            } else {
                this.collection.batchAction(evtObj.target.dataset.action).always(() => {
                    evtObj.currentTarget.classList.remove(loadBtnClass);
                });
            }
        }
    },

    serializeData() {
        return {
            btns: [
                {
                    action: 'start',
                    label: 'Start',
                    icon: 'images/icons/play-icon.svg',
                    bgsize: 14
                },
                {
                    action: 'stop',
                    label: 'Stop',
                    icon: 'images/icons/stop-icon.svg',
                    bgsize: 14
                },
                {
                    action: 'increase_priority',
                    label: 'Inc. priority',
                    icon: 'images/icons/arrow-icon.svg',
                    bgsize: 12
                },
                {
                    action: 'delete',
                    label: 'Remove',
                    icon: 'images/icons/trash.svg',
                    bgsize: 12
                }
            ]
        };
    },

    onClose() {
        this.stopListening(Backbone, BasicCollection.BATCH_ACTION_RESULT_EVENT);
    }
});

module.exports = BatchControlsView;
