const error = require('../../../error');
const notification = require('../../../notification');
const BasicConfirmDialogView = require('../../components/BasicConfirmDialogView');

/**
 * @class ClientsBatchActionConfirm
 * @extends BasicConfirmDialogView
 *
 * @property {Object}   options
 * @property {String}   options.action
 * @property {Number[]} options.selectedItems
 */
const ClientsBatchActionConfirm = BasicConfirmDialogView.extend({

    template: require('./tpl/ClientsBatchActionConfirm.hbs'),

    events: {
        approve: 'onApprove'
    },

    onApprove() {
        const self = this;

        $.ajax({
            url: '/api/v1.0/batch/clients/' + this.options.action,
            type: 'PUT',
            data: JSON.stringify(this.options.selectedItems),
            dataType: 'json',
            contentType: 'application/json'
        })
            .done(() => {
                notification.message('Action «' +
                self.options.action.toUpperCase() +
                '» finished successfully for selected hosts');
            })
            .fail(error.fromXHR)
            .always(() => {
                self.close();
            });
    },

    serializeData() {
        return {
            action: this.options.action,
            count: this.options.selectedItems.length
        };
    }

});

module.exports = ClientsBatchActionConfirm;
