const error = require('../../../error');

/**
 * @class ClientsBatchCommentsControl
 * @extends Marionette.ItemView
 */
const ClientsBatchCommentsControl = Marionette.ItemView.extend({

    className: 'clients-batch-controls',

    options: {
        activeClass: 'clients-batch-controls_opened',
        standByLabel: 'Comment',
        activeLabel: 'Apply comment'
    },

    template: require('./tpl/ClientsBatchCommentsControl.hbs'),

    ui: {
        input: '.input input',
        button: '.button',
        buttonLabel: '.button__label'
    },

    events: {
        'click @ui.button': 'onAction'
    },

    collectionEvents: {
        msgUpdateFailed: 'onError'
    },

    initialize() {
        this.onError = _.debounce(this.onError, 300);
    },

    onRender() {
        $('.input').bemmyInput();
    },

    onError() {
        error.message('Error occured when we tried to set comments to one ore more clients.');
    },

    onAction() {
        if (this.el.classList.contains(this.options.activeClass)) {
            this.collection.each(function (client) {
                client.set('msg', this.ui.input.val());
            }, this);

            this.ui.buttonLabel.text(this.options.standByLabel);
            this.el.classList.remove(this.options.activeClass);
        } else {
            this.ui.buttonLabel.text(this.options.activeLabel);
            this.el.classList.add(this.options.activeClass);
        }
    }
});

module.exports = ClientsBatchCommentsControl;
