/**
 * @class ModeSwitcherView
 * @extends Backbone.Marionette.ItemView
 *
 * @property {CoreApplication} model
 */
const ModeSwitcherView = Marionette.ItemView.extend({

    tagName: 'td',
    className: 'c c_max c_right client_mode_switcher',

    template: require('./tpl/ModeSwitcherView.hbs'),

    ui: {
        switcher: '.client_view_mode'
    },

    events: {
        'bemmy:set @ui.switcher': 'onModeSwitched'
    },

    initialize(options) {
        this.options = _.extend({}, this.options, options);
    },

    onModeSwitched(evtObj, value) {
        this.options.parent.trigger('change:mode', value);
    },

    serializeData() {
        return {
            mode: this.options.mode || 'compact'
        };
    }
});

module.exports = ModeSwitcherView;
