const CreateTaskControlSectionLayout = require('../createTask/CreateTaskControlSectionLayout');
const SingleSchedulerControlSectionLayout = require('../singleScheduler/SingleSchedulerControlSectionLayout');

/**
 * @class CreateSchedulerControlSectionLayout
 * @extends CreateTaskControlSectionLayout
 *
 * @property {SchedulerModel} model
 */
const CreateSchedulerControlSectionLayout = CreateTaskControlSectionLayout.extend({

    template: require('./tpl/CreateSchedulerControlSectionLayout.hbs'),

    behaviors: SingleSchedulerControlSectionLayout.prototype.behaviors,

    serializeData() {
        return {
            id: this.model.get('id'),
            type: this.model.task.get('type'),
            description: this.getTaskTypeDescription()
        };
    }
});

module.exports = CreateSchedulerControlSectionLayout;
