const SingleTaskControlSectionLayout = require('../singleTask/SingleTaskControlSectionLayout');

/**
 * @class CreateTaskControlSectionLayout
 * @extends SingleTaskControlSectionLayout
 */
const CreateTaskControlSectionLayout = SingleTaskControlSectionLayout.extend({

    template: require('./tpl/CreateTaskControlSectionLayout.hbs'),

    initialize(options) {
        this.options = _.extend({}, this.options, options);
    },

    onRender() {},

    getTaskTypeDescription() {
        let description = 'NO description';

        if (this.options.taskTypes) {
            const selfType = this.model.getType();
            const taskDescr = (this.options.taskTypes.find(type => {
                return type.get('type') === selfType;
            }));

            if (taskDescr) {
                description = taskDescr.get('description');
            }
        }

        return description;
    },

    serializeData() {
        return {
            id: this.model.get('id'),
            type: this.model.get('type'),
            description: this.getTaskTypeDescription()
        };
    }
});

module.exports = CreateTaskControlSectionLayout;
