const app = require('../../../app');

/* eslint max-len: [1, 122] */

const FilterPresetSavePromptView = require('../../controlSection/filter/presetSaveConfirm/FilterPresetSavePromptView');

/**
 * @description Abstract basic filter class. Utilizes common filter functionality.
 *
 * @class BasicFilterLayout
 * @extends Backbone.Marionette.Layout
 *
 * @property {Backbone.Model}      model
 * @property {Backbone.Collection} collection
 */
const BasicFilterLayout = Marionette.Layout.extend({

    options: {
        applyBtnActiveClass: 'button_type_hl'
    },

    modelEvents: {
        change: 'onModelChange',
        blank: 'render'
    },

    ui: {
        apply: '.filter_apply',
        reset: '.filter_reset',
        save: '.filter_save'
    },

    events: {
        'click @ui.apply': 'onApply',
        'click @ui.reset': 'onReset',
        'click @ui.save': 'onSave'
    },

    onModelChange() {
        this.ui.apply.addClass(this.options.applyBtnActiveClass);
    },

    onApply(evtObj) {
        if (evtObj) {
            evtObj.preventDefault();
        }

        const filterValues = this.model.clone();

        app.trigger('change:filterparams:preset', filterValues);
        this.ui.apply.removeClass(this.options.applyBtnActiveClass);
        this.updateLastFilter(filterValues);
    },

    onReset(evtObj) {
        evtObj.preventDefault();

        this.model.setDefaults();
        this.ui.apply.removeClass(this.options.applyBtnActiveClass);

        this.trigger('reset:after');
    },

    onSave(evtObj) {
        evtObj.preventDefault();

        (new FilterPresetSavePromptView({
            model: this.model.clone(),
            collection: this.options.user.getPresets()
        })).show();
    },

    updateLastFilter() {
        return false;
    }
});

module.exports = BasicFilterLayout;
