const BasicConfirmDialogView = require('../../../components/BasicConfirmDialogView');
// eslint-disable-next-line no-unused-vars
const resources = require('../../../../resources');
// eslint-disable-next-line no-unused-vars
const error = require('../../../../error');

/**
 * @class FilterPresetSavePromptView
 * @extends BasicConfirmDialogView
 *
 * @property {FilterModel} model
 * @property {UserPresetsCollection} collection
 */
const FilterPresetSavePromptView = BasicConfirmDialogView.extend({

    template: require('./tpl/FilterPresetSavePromptView.hbs'),

    ui: {
        input: '.input__input'
    },

    events: {
        approve: 'onApprove'
    },

    behaviors: {
        BasicConfirmDialogBehavior: {
            approveOnEnter: true
        }
    },

    /**
     * @override {@link BasicConfirmDialogView#onApprove}
     */
    onApprove() {
        this.model.setTitle(this.ui.input.val());
        this.model.getFound();

        this.collection.addPreset(this.model);

        this.close();
    },

    serializeData() {
        return {};
    }

});

module.exports = FilterPresetSavePromptView;
