/* eslint no-useless-escape: 0 */

const TaskTypeAutocompleteItemView = Marionette.ItemView.extend({

    tagName: 'li',
    className: 'autocomplete_item',
    template: require('./tpl/TaskTypeAutocompleteItemView.hbs'),

    initialize() {
        this.sanitizeSearchValue();
    },

    onRender() {
        this.$el.data('suggest-value', this.model.get('label'));
    },

    serializeData() {
        let label = this.model.get('label');
        let descr = this.model.get('description');

        if (this.options.searchValue) {
            label = label.replace(
                (new RegExp('(' + this.options.searchValue + ')', 'i')),
                '<span class="suggest_search_match">$1</span>'
            );

            if (descr) {
                descr = descr.replace(
                    (new RegExp('(' + this.options.searchValue + ')', 'i')),
                    '<span class="suggest_search_match">$1</span>'
                );
            }
        }

        return {
            label,
            description: descr
        };
    },

    sanitizeSearchValue() {
        if (this.options.searchValue) {
            this.options.searchValue = this.options.searchValue.replace(/[\(\)\\\[\+\]\$\^\?\|]/, '.');
        }
    }
});

module.exports = TaskTypeAutocompleteItemView;
