const SingleOwnerSuggestGroupModel = require('../../../../model/suggest/filter/SingleOwnerSuggestGroupModel');
// eslint-disable-next-line no-unused-vars
const OwnersSuggestGroupModel = require('../../../../model/suggest/filter/OwnersSuggestGroupModel');
const BasicSuggestView = require('../../../components/BasicSuggestView');

/**
 * @class AuthorSuggestView
 * @extends BasicSuggestView
 */
const AuthorSuggestView = BasicSuggestView.extend({

    className: 'app_filter_author',

    options: {
        opened: false,
        openedClass: 'select_open',
        placeholder: 'Author',
        defaultValue: '',
        modelTargetKey: 'author'
    },

    setSuggestGroups() {
        this.collection.add(new SingleOwnerSuggestGroupModel());
    }
});

module.exports = AuthorSuggestView;
