const SingleOwnerSuggestGroupModel = require('../../../../model/suggest/filter/SingleOwnerSuggestGroupModel');
const OwnersSuggestGroupModel = require('../../../../model/suggest/filter/OwnersSuggestGroupModel');
const BasicSuggestView = require('../../../components/BasicSuggestView');

/**
 * @class OwnerSuggestView
 * @extends BasicSuggestView
 */
const OwnerSuggestView = BasicSuggestView.extend({

    className: 'app_filter_owner',

    options: {
        opened: false,
        openedClass: 'select_open',
        placeholder: 'Owner',
        defaultValue: '',
        clearOnSelect: false,
        modelTargetKey: 'owner'
    },

    onRender() {
        this.ui.inputCnt.bemmyInput();
        this.mapModelToView();
    },

    setSuggestGroups() {
        this.collection.add(new OwnersSuggestGroupModel({}, {
            basicItemsSet: this.options.ownerGroups,
            defaultFilter() {
                return false;
            }
        }));

        if (!this.options.onlyGroups) {
            this.collection.add(new SingleOwnerSuggestGroupModel());
        }
    }
});

module.exports = OwnerSuggestView;
