const app = require('../../../app');
const ReleaseFilter = require('../../releases/ReleaseFilter');
const ControlSectionLayout = require('../ControlSectionLayout');

/**
 * @class ReleasesListControlSection
 * @extends ControlSectionLayout
 */
const ReleasesListControlSection = ControlSectionLayout.extend({

    className: 'section__ii section__ii_filter section__ii_filter__release',

    onRender() {
        this.filter.close();
        this.filter.show(this.getFilter());
    },

    getFilter() {
        const currentType = app.getCurrentFilter();
        const defaultFilters = app.getDefaultFilter();

        return new ReleaseFilter({
            user: this.model.getUser(),
            model: defaultFilters && defaultFilters[currentType] && defaultFilters[currentType].clone(),
            collection: this.collection,
            releaseProps: this.model.getProps(),
            isAutoupdateEnabled: this.model.getPageProps().isAutoupdateEnabled
        });
    }
});

module.exports = ReleasesListControlSection;
