const app = require('../../../app');
const ResourceListBatchControlsView = require('./batchControls/ResourceListBatchControlsView');
const SelectResourceFilterView = require('../../createTask/customProps/SelectResourceFilterView');
const ControlSectionLayout = require('../ControlSectionLayout');

const ResourcesListControlSection = ControlSectionLayout.extend({

    onShow() {
        this.controls.close();
        this.filter.close();
        this.controls.show(this.getBatchControls());
        this.filter.show(this.getFilter());
    },

    getFilter() {
        const currentType = app.getCurrentFilter();
        const defaultFilters = app.getDefaultFilter();

        return new SelectResourceFilterView({
            user: this.model.getUser(),
            model: defaultFilters && defaultFilters[currentType] && defaultFilters[currentType].clone(),
            isModal: false,
            taskProps: this.model.getProps(),
            collection: this.collection
        });
    },

    getBatchControls() {
        return new ResourceListBatchControlsView({
            collection: this.collection
        });
    }
});

module.exports = ResourcesListControlSection;
