/* eslint max-len: [1, 140] */

const info = require('../../../../info');
const BatchControlsView = require('../../batchControls/BatchControlsView');
const resourceSuccessNotificationMessage = require('../../../components/globalMessage/tpl/resourceSuccessNotificationMessage.hbs');

/**
 * @class  ResourceListBatchControlsView
 * @extends BatchControlsView
 */
const ResourceListBatchControlsView = BatchControlsView.extend({

    onBatchResult(results, action) {
        BatchControlsView.prototype.onBatchResult.apply(this, arguments);

        if (results.SUCCESS.length &&
            results.ERROR.length === 0 && results.WARNING.length === 0 &&
            (action === 'reshare' || action === 'restore')) {
            info.message(resourceSuccessNotificationMessage({
                qnt: results.SUCCESS.length,
                action
            }), { reload: false });
        }
    },

    serializeData() {
        return {
            btns: [
                { action: 'delete', label: 'Remove', icon: 'images/icons/trash.svg', bgsize: 12 },
                { action: 'do_not_remove', label: 'Important', icon: 'images/icons/flag-icon.svg', bgsize: 16 },
                { action: 'restore', label: 'Restore', icon: 'images/icons/restore.svg', bgsize: 15 },
                { action: 'reshare', label: 'Reshare', icon: 'images/icons/reshare.svg', bgsize: 12 },
                { action: 'backup', label: 'Backup', icon: 'images/icons/backup.svg', bgsize: 10 }
            ]
        };
    }
});

module.exports = ResourceListBatchControlsView;
