/* eslint camelcase: 0 */

const app = require('../../../app');
// eslint-disable-next-line no-unused-vars
const OwnerSuggestView = require('../filter/suggest/OwnerSuggestView');
// eslint-disable-next-line no-unused-vars
const AuthorSuggestView = require('../filter/suggest/AuthorSuggestView');
const BasicFilterLayout = require('../filter/BasicFilterLayout');
// eslint-disable-next-line no-unused-vars
const TaskTypeAutocompleteView = require('../filter/selects/autocomplete/TaskTypeAutocompleteView');

/**
 * @class SandboxNotificationsFilterView
 * @extends BasicFilterLayout
 */
const SandboxNotificationsFilterView = BasicFilterLayout.extend({

    template: require('./tpl/SandboxNotificationsFilterView.hbs'),

    ui: _.extend({}, BasicFilterLayout.prototype.ui, {
        transport: '.transport',
        is_sent: '.is_sent',
        from: '.from',
        to: '.to',

        fromInput: '.from input',
        toInput: '.to input',

        inboxTrigger: '.inbox_trigger',
        sentTrigger: '.sent_trigger'
    }),

    events: _.extend({}, BasicFilterLayout.prototype.events, {
        'bemmy:refresh @ui.from': 'onFromChange',
        'bemmy:refresh @ui.to': 'onToChange',

        'bemmy:set @ui.transport': 'onTransportChange',
        'bemmy:set @ui.is_sent': 'onIsSentChange',

        'click @ui.inboxTrigger': 'updateRecipient',
        'click @ui.sentTrigger': 'updateAuthor'
    }),

    modelEvents: {
        change: 'onModelChange',
        'change:author': 'mapModelToView',
        'change:recipient': 'mapModelToView',
        'change:transport': 'mapModelToView'
    },

    behaviors: {
        FormAcceptBehavior: {}
    },

    onRender() {
        this.mapModelToView();

        this.$('.input').bemmyInput();
        this.$('.check').bemmyCheck();
        this.$('.select').bemmySelect();
    },

    onTransportChange(evtObj, value) {
        this.model.set('transport', value);
    },

    onIsSentChange(evtObj, value) {
        this.model.set('sent', value);
    },

    onFromChange() {
        this.model.set('author', this.ui.fromInput.val());
    },

    onToChange() {
        this.model.set('recipient', this.ui.toInput.val());
    },

    mapModelToView() {
        this.ui.transport.trigger('bemmy:set', this.model.get('transport'));

        this.ui.toInput.val(this.model.get('recipient'));
        this.ui.fromInput.val(this.model.get('author'));
    },

    serializeData() {
        const user = this.options.user.get('login');

        return _.extend({
            login: user,
            isSent: (user === this.model.get('author')),
            isInbox: (user === this.model.get('recipient')),
            isAdmin: this.options.user.isAdmin()
        }, this.model.toJSON());
    },

    /**
     * @override
     * @param {Backbone.Model} filterValues - filter model
     */
    updateLastFilter(filterValues) {
        const defaultFilter = app.request('DEFAULT_FILTER');

        defaultFilter.sandboxNotificationsList = filterValues.clone();
        defaultFilter.sandboxNotificationsList.saveFilterState();
    },

    updateRecipient(evtObj) {
        evtObj.preventDefault();

        this.model.set('recipient', this.options.user.get('login'));
        this.onApply(evtObj);

        this.ui.inboxTrigger.addClass('cur');
        this.ui.sentTrigger.removeClass('cur');
    },

    updateAuthor(evtObj) {
        evtObj.preventDefault();

        this.model.set('author', this.options.user.get('login'));
        this.onApply(evtObj);

        this.ui.sentTrigger.addClass('cur');
        this.ui.inboxTrigger.removeClass('cur');
    }
});

module.exports = SandboxNotificationsFilterView;
