const app = require('../../../app');
const SchedulersBatchControlsView = require('./batchControls/SchedulersBatchControlsView');
const SchedulersListFilterView = require('./filter/SchedulersListFilterView');
const ControlSectionLayout = require('../ControlSectionLayout');

/**
 * @class SchedulersListControlSection
 * @extends ControlSectionLayout
 */
const SchedulersListControlSection = ControlSectionLayout.extend({

    onShow() {
        this.controls.close();
        this.filter.close();
        this.controls.show(this.getBatchControls());
        this.filter.show(this.getFilter());
    },

    getFilter() {
        const currentType = app.getCurrentFilter();
        const defaultFilters = app.getDefaultFilter();

        return new SchedulersListFilterView({
            user: this.model.getUser(),
            model: defaultFilters && defaultFilters[currentType] && defaultFilters[currentType].clone(),
            props: this.model.getProps(),
            collection: this.collection
        });
    },

    getBatchControls() {
        return new SchedulersBatchControlsView({
            collection: this.collection
        });
    }
});

module.exports = SchedulersListControlSection;
