const BatchControlsView = require('../../batchControls/BatchControlsView');

/**
 * @class SchedulersBatchControlsView
 * @extends BatchControlsView
 *
 * @property {SchedulersCollection} collection
 */
const SchedulersBatchControlsView = BatchControlsView.extend({

    ui: {
        buttons: '.button'
    },

    serializeData() {
        return {
            btns: [
                { action: 'delete', label: 'Delete', icon: 'images/icons/trash.svg', bgsize: 12 },
                { action: 'stop', label: 'Stop', icon: 'images/icons/stop-icon.svg', bgsize: 14 },
                { action: 'start', label: 'Start', icon: 'images/icons/play-icon.svg', bgsize: 14 }
            ]
        };
    }
});

module.exports = SchedulersBatchControlsView;
