const SemaphoreFilterView = require('../../admin/manageSemaphore/SemaphoreFilterView');
const ManageSemaphoresControls = require('../../controlSection/adminControls/ManageSemaphoresControls');

/**
 * @class SemaphoresListControlSection
 * @extends Marionette.Layout
 *
 * @property {CoreApplication} model
 * @property {TasksCollection} collection
 */
const SemaphoresListControlSection = Marionette.Layout.extend({

    className: 'section__ii section__ii_filter app_temp_padding_remover',

    template: require('./tpl/SemaphoresListControlSection.hbs'),

    onShow() {
        this.controls.close();
        this.filter.close();
        this.controls.show(this.getBatchControls());
        this.filter.show(this.getFilter());
    },

    getFilter() {
        return new SemaphoreFilterView({
            user: this.model.getUser(),
            model: this.collection.getFilterParams(),
            taskProps: this.model.getProps(),
            collection: this.collection
        });
    },

    getBatchControls() {
        return new ManageSemaphoresControls({
            collection: this.collection,
            model: this.model
        });
    }
});

module.exports = SemaphoresListControlSection;
