const notification = require('../../../notification');
const TaskResourcesCollection = require('../../../collection/TaskResourcesCollection');
const ResourceRemoveConfirmView = require('../../tasks/taskRemoveConfirm/ResourceRemoveConfirmView');
const SingleResourceSecNavigation = require('../../navigation/secnavigation/SingleResourceSecNavigation');
const SingleItemViewControlSectionLayout = require('../SingleItemViewControlSectionLayout');

const restoredResourceNotification =
    require('../../../views/components/infoPanels/tpl/restoredResourceNotification.hbs');

const clipboardClientMixin = require('../../components/clipboardClient/ClipboardClientMixin');

/**
 * @class SingleResourceControlSectionLayout
 * @extends SingleItemViewControlSectionLayout
 *
 * @property {TaskResourceModel} model
 */
const SingleResourceControlSectionLayout = SingleItemViewControlSectionLayout.extend({

    className: 'section__title',

    template: require('./tpl/compact/SingleResourceControlSectionLayout.hbs'),

    ui: _.extend({}, SingleItemViewControlSectionLayout.prototype.ui, {
        actionBtn: '.action_btn',
        editTrigger: '.edit_btn'
    }),

    events: _.extend({}, SingleItemViewControlSectionLayout.prototype.events, {
        'click @ui.actionBtn': 'onAction'
    }),

    initialize(options) {
        this.options = _.extend({}, this.options, options);
    },

    onAction(evtObj) {
        const action = $.trim(evtObj.currentTarget.className.replace(/(action_btn)|(button(_size_.{1})?)/ig, ''));

        if (action === TaskResourcesCollection.BATCH_OPERATIONS.DELETE) {
            (new ResourceRemoveConfirmView({
                model: this.model
            })).show();
        } else {
            TaskResourcesCollection
                .batchAction(action, [this.model])
                .done(response => {
                    const result = response[0];

                    if (result && result.status === 'SUCCESS') {
                        notification.message(restoredResourceNotification({
                            id: result.id,
                            action,
                            label: { reshare: 'RESHARE', restore: 'RESTORE' }[action]
                        }), {
                            reload: false
                        });
                    }
                });
        }
    },

    onRender() {
        this.model.fetchDependant().done(() => {
            this.secnavigation.close();
            this.secnavigation.show(new SingleResourceSecNavigation({
                model: this.options.coreApp,
                layout: this.options.layout
            }));
        });

        clipboardClientMixin.initializeClipboardClient(
            '.id-proxy-copier',
            'Resource ID has been copied to clipboard.'
        );
    },

    serializeData() {
        const serialized = _.clone(this.model.attributes);
        const rType = this.options.taskProps.resourceTypes.where({ type: serialized.type });

        serialized.typeDescription = (rType[0] ? rType[0].get('description') : '');
        serialized.canBeRestored = this.model.canBeRestored();
        serialized.canBeChanged = this.model.canBeChanged();

        return serialized;
    }
});

module.exports = SingleResourceControlSectionLayout;
