const ActionErrorModalView = require('./ActionErrorModalView');

/**
 * @class SingleTaskActionErrorModalView
 * @extends ActionErrorModalView
 */
const SingleTaskActionErrorModalView = ActionErrorModalView.extend({

    template: require('./tpl/SingleTaskActionErrorModalView.hbs'),

    initialize() {
        ActionErrorModalView.prototype.initialize.apply(this, arguments);
        this.fetchTrace();
    },

    fetchTrace() {
        if (this.options.id && this.options.action === 'start') {
            const self = this;

            $.ajax({
                url: ('/api/v1.0/task/' + this.options.id + '/context'),
                type: 'GET',
                dataType: 'json',
                contentType: 'application/json'
            }).done(response => {
                self.options.trace = response.__last_error_trace ?
                    response.__last_error_trace :
                    'No trace got from server.';
                self.render();
            }).fail(() => {
                self.options.trace = 'No trace got from server.';
                self.render();
            });
        }
    },

    serializeData() {
        return {
            trace: this.options.trace,
            action: this.options.action.toUpperCase(),
            message: this.options.message
        };
    }
});

module.exports = SingleTaskActionErrorModalView;
