const ResourcesCollection = require('../../../collection/TaskResourcesCollection');
const XmlrpcStatisticsControls = require('./XmlrpcStatisticsControls');

/**
 * @class RestStatisticsControls
 * @extends XmlrpcStatisticsControls
 *
 * @property {TaskResourceModel} model
 */
const RestStatisticsControls = XmlrpcStatisticsControls.extend({

    getStatResourceCollection() {
        const resources = new ResourcesCollection([], { order: '-id' });

        resources.mapFilterQueryOptions({
            type: 'SANDBOX_API_STATISTICS',
            attrs: JSON.stringify({
                date: moment().subtract(this.statDateBefore, 'days').format('YYYY-MM-DD'),
                type: 'rest'
            })
        });

        return resources;
    }
});

module.exports = RestStatisticsControls;
