/* eslint complexity: [1, 11] */

const ListModel = require('../../model/ListModel');
const CreateTaskCustomListView = require('./CreateResourceCustomListView');

/**
 * @class ResourceListConfigView
 * @extends Backbone.Marionette.ItemView
 */
module.exports = Marionette.Layout.extend({

    className: 'section__list section__list_ctrl',

    tagName: 'tr',

    template: require('./tpl/ResourceListConfigView.hbs'),

    ui: {
        addItem: '.add_item'
    },

    events: {
        'click @ui.addItem': 'onAddItem'
    },

    initialize(options) {
        this._generateCollection();

        this.options = _.extend({}, this.options, options);
    },

    onRender() {
        this.addRegions({ dynamicList: '#dynamicList' });

        this.showItems();
    },

    onAddItem() {
        this._generateCollectionItem(null, null, 'add');
    },

    showItems() {
        this.dynamicList.close();
        this.dynamicList.show(new Marionette.CollectionView({
            tagName: 'tbody',
            collection: this.collection,
            itemView: CreateTaskCustomListView,
            itemViewOptions: {
                fieldViewMode: 'edit',
                taskProps: this.options.taskProps
            }
        }));
    },

    onDynamicListChange() {
        let value = null;
        let name = this.name;
        let context = null;
        const resultList = new ListModel();

        resultList.urlRoot = this.url;

        this.collection.each(item => {
            context = context || item.get('context');
            name = name || item.get('name');
            value = value || {};

            if (item.get('value') || item.get('contextValue')) {
                value[item.get('value') || ''] = item.get('contextValue') || '';
            }
        });

        this.options.model.set(this.options.modelTargetKey, value);
    },

    /**
     * Генерируем коллекцию моделей list / dict по данным из ручек
     * @private
     */
    _generateCollection() {
        const self = this;
        const items = self.model.get('value');
        const isEmptyArray = items && items instanceof Array && !items.length;
        const isEmptyObject = items &&
            items.toString &&
            items.toString() === '[object Object]' &&
            Object.keys(items) &&
            Object.keys(items).length === 0;
        const isEmpty = !items || isEmptyArray || isEmptyObject;

        if (isEmpty) {
            self._generateCollectionItem();
        } else {
            _.forEach(items, (contextValue, value) => {
                if (items instanceof Array) {
                    value = contextValue;
                    contextValue = null;
                }

                if (self.collection) {
                    self._generateCollectionItem(value, contextValue, 'add');
                } else {
                    self._generateCollectionItem(value, contextValue);
                }
            });
        }

        if (self.collection) {
            self.collection.name = self.model.get('name');
        }
    },

    _generateCollectionItem(key, val, type) {
        let attributes = {};

        if (key) {
            attributes = Object.assign(attributes, { value: key });
        }

        if (val) {
            attributes = Object.assign(attributes, { contextValue: val });
        }

        if (type) {
            this.collection.add(new ListModel(attributes));
        } else {
            this.collection = new Backbone.Collection(new ListModel(attributes));
        }

        this.listenTo(this.collection, 'change remove', this.onDynamicListChange, this.collection);
    },

    onClose() {
        this.stopListening(this.collection, 'change remove');
    }
});
