// eslint-disable-next-line no-unused-vars
const Timer = require('../../helpers/utils/Timer');
// eslint-disable-next-line no-unused-vars
const TimeInterval = require('../components/timeInterval/TimeInterval');

/**
 * @class SchedulerWeeklyRepetitionView
 * @extends Marionette.ItemView
 *
 * @property {SchedulerModel} model
 */
const SchedulerWeeklyRepetitionView = Marionette.ItemView.extend({

    className: 'b b_top b_gap-x_M b_se-2-3',
    template: require('./tpl/SchedulerWeeklyRepetition.hbs'),

    ui: {
        days: '.check'
    },

    events: {
        'bemmy:set @ui.days': 'onSetDay'
    },

    modelEvents: {
        'change:schedule': 'render'
    },

    onRender() {
        this.$('.check').bemmyCheck();
    },

    onSetDay() {
        const days = [];

        this.$('.check.checked').each((index, el) => {
            days.push(parseInt($(el).find('input').val(), 10));
        });

        this.model.setWeeklyRepetition(days);
    },

    serializeData() {
        const schedule = this.model.get('schedule');

        return {
            days: (schedule && schedule.repetition && schedule.repetition.weekly ? schedule.repetition.weekly : [])
        };
    }

});

module.exports = SchedulerWeeklyRepetitionView;
