/**
 * @class CreateTaskDNSConfigView
 * @extends Marionette.ItemView
 *
 * @property {TaskModel} model
 */
const CreateTaskDNSConfigView = Marionette.ItemView.extend({

    tagName: 'td',
    className: 'c',

    template: require('./tpl/CreateTaskDNSConfigView.hbs'),

    ui: {
        dnsClass: '.dns-class',
        dnsClassBtns: '.dns-class .button'
    },

    events: {
        'bemmy:set @ui.dnsClass': 'onDnsClassChange'
    },

    modelEvents: {
        'invalid:dns': 'onValidationError'
    },

    initialize() {
        const requirements = this.model.get('requirements') || {};

        if (!requirements.dns) {
            this.model.set(
                'requirements',
                Object.assign({}, requirements, { dns: 'default' })
            );
        }
    },

    onRender() {
        this.$('.button').bemmyButton();
    },

    onDnsClassChange(evtObj, value) {
        evtObj.preventDefault();

        const requirements = this.model.get('requirements') || {};

        if (requirements.dns !== value) {
            this.model.set(
                'requirements',
                Object.assign(
                    {},
                    requirements,
                    { dns: value }
                )
            );
        }
    },

    onValidationError(err) {
        this.ui.popup_text.text(err.message);
        this.ui.popup.addClass('popup_visible');
    },

    serializeData() {
        const items = (this.options.dns && this.options.dns.toJSON && this.options.dns.toJSON()) || [];

        return {
            items,
            active: (this.model.get('requirements') || {}).dns || 'default'
        };
    }
});

module.exports = CreateTaskDNSConfigView;
