/* eslint camelcase: 0 */

const badgeTemplate = require('./tpl/CreateTaskAvailableHostsBadge.hbs');
const AutoCompleteView = require('../controlSection/filter/selects/autocomplete/AutocompleteView');

/**
 * @class CreateTaskHostsConfigView
 * @extends Marionette.Layout
 *
 * @property {TaskModel} model
 * @property {Marionette.Region} hostSelector
 */
const CreateTaskHostsConfigView = Marionette.Layout.extend({

    tagName: 'td',
    className: 'c c_gap_XS',

    template: require('./tpl/CreateTaskHostsConfigView.hbs'),

    options: {
        cpuModels: [],
        platforms: [],
        hosts: [],

        total: 0,
        available: 0
    },

    ui: {
        select: 'select',
        os: '.select_os select',
        cpu: '.select_cpu select',
        host: '.select_host',
        badge: '.badge'
    },

    events: {
        'change @ui.select': 'onChangedFilter',
        'change @ui.host': 'onDebouncedChangedFilter',
        'input @ui.host': 'onDebouncedChangedFilter'
    },

    initialize(options) {
        this.options = _.extend({}, this.options, options);
        this.options.total = this.options.hosts ?
            this.options.hosts.length :
            0;
        this.options.available = this.options.total;

        this.onDebouncedChangedFilter = _.debounce(this.onChangedFilter, 150).bind(this);
    },

    onRender() {
        const requirements = this.model.get('requirements');

        this.$('.select').bemmySelect();

        this.hostSelector.close();
        this.hostSelector.show(new AutoCompleteView({
            items: this.options.hosts,
            value: (requirements ? requirements.host : ''),
            model: new Backbone.Model(),
            showAnyItem: true,
            placeHolder: 'Host',
            modelTargetKey: 'host',
            selectClassName: 'select_host'
        }));

        this.bindUIElements();

        this.onChangedFilter();
    },

    onChangedFilter() {
        const self = this;

        this.updateHostInfo();
        this.getAvailiableHostInfo().done(available => {
            self.options.available = available;
            self.renderBadge();
        });
    },

    updateHostInfo() {
        const requirements = this.model.get('requirements');
        const updatedHostInfo = this.getRequestData();

        delete updatedHostInfo.task_type;

        this.model.set('requirements', Object.assign(requirements, {
            host: updatedHostInfo.host,
            platform: updatedHostInfo.platform,
            cpu_model: updatedHostInfo.cpu,
            disk_space: requirements.disk_space
        }));
    },

    getAvailiableHostInfo() {
        const self = this;

        return $.ajax({
            url: '/api/v1.0/suggest/client',
            type: 'GET',
            data: this.getRequestData(),
            complete() {
                if (self.ui.badge && self.ui.badge.removeClass) {
                    self.ui.badge.removeClass('loading');
                }
            },
            beforeSend() {
                if (self.ui.badge) {
                    self.ui.badge.addClass('loading');
                }
            }
        }).then(response => {
            return (response.hosts ? response.hosts.length : 0);
        });
    },

    serializeData() {
        return _.extend({}, this.model.get('requirements'), this.options);
    },

    renderBadge() {
        if (this.ui.badge && this.ui.badge.html) {
            this.ui.badge.html(badgeTemplate({
                forced: !this.options.available && this.ui.host.val(),
                total: this.options.total,
                available: this.options.available
            }));
        }
    },

    getRequestData() {
        return {
            task_type: this.model.get('type'),
            platform: this.filterDefault(this.ui.os.val()),
            host: this.filterDefault(this.ui.host.val()),
            cpu: this.filterDefault(this.ui.cpu.val())
        };
    },

    filterDefault(value) {
        return (value === '--' ? '' : value);
    }
});

module.exports = CreateTaskHostsConfigView;
