// eslint-disable-next-line no-unused-vars
const TaskModel = require('../../model/TaskModel');
const NotificationModel = require('../../model/NotificationModel');
const StatusSelectorView = require('../components/statusSelector/StatusSelectorView');
const NotificationRecipientSuggestView = require('./NotificationRecipientSuggestView');

/**
 * @class CreateTaskNotification
 * @extends Backbone.Marionette.Layout
 */
const CreateTaskNotification = Marionette.Layout.extend({

    tagName: 'tr',
    className: 'create_task_notification',

    template: require('./tpl/CreateTaskNotification.hbs'),

    ui: {
        button: '.transport_selector',
        remover: '.delete_notification_group'
    },

    events: {
        'bemmy:set @ui.button': 'onTransportChange',
        'click @ui.remover': 'onRemoveGroup'
    },

    options: {
        form: false
    },

    /** REGIONS DEFINED DIRECTLY IN THE TEMPLATE */

    initialize(options) {
        this.options = _.extend({}, this.options, options);
    },

    onRender() {
        this.$('.button').bemmyButton();

        this.statusSelector.close();
        this.statusSelector.show(new StatusSelectorView({
            model: this.model,
            statusField: 'statuses'
        }));

        this.recipientSelector.close();
        this.recipientSelector.show(new NotificationRecipientSuggestView({
            fetchMailingLists: true,
            ownerGroups: this.options.taskProps.groups.convertToList(),
            model: this.model
        }));
    },

    onTransportChange(evtObj, value) {
        this.model.set('transport', value);
    },

    onRemoveGroup() {
        this.model.collection.remove(this.model);
    },

    serializeData() {
        const currentTransport = this.model.get('transport');

        return {
            form: this.options.form,
            transport: [
                {
                    value: NotificationModel.TRANSPORT.EMAIL,
                    selected: NotificationModel.TRANSPORT.EMAIL === currentTransport
                },
                {
                    value: NotificationModel.TRANSPORT.JABBER,
                    selected: NotificationModel.TRANSPORT.JABBER === currentTransport
                }
            ]
        };
    }
});

module.exports = CreateTaskNotification;
