const NotificationModel = require('../../model/NotificationModel');
const CreateTaskNotification = require('./CreateTaskNotification');

/**
 * @class CreateTaskNotifyConfig
 * @extends Backbone.Marionette.ItemView
 */
const CreateTaskNotifyConfig = Marionette.Layout.extend({

    className: 'section__form section__form_ctrl',

    template: require('./tpl/CreateTaskNotifyConfig.hbs'),

    ui: {
        addTrigger: '.add_notification'
    },

    events: {
        'click @ui.addTrigger': 'onAddNotification'
    },

    initialize(options) {
        this.options = _.extend({}, this.options, options);
    },

    onRender() {
        this.showNotifications();
    },

    onAddNotification() {
        this.collection.add(new NotificationModel());
    },

    showNotifications() {
        this.notifications.close();
        this.notifications.show(new Marionette.CollectionView({
            tagName: 'tbody',
            collection: this.collection,
            itemView: CreateTaskNotification,
            itemViewOptions: {
                taskProps: this.options.taskProps
            }
        }));
    }
});

module.exports = CreateTaskNotifyConfig;
