/* eslint camelcase: 0 */

/**
 * @class CreateTaskOwnerConfigView
 * @extends Marionette.ItemView
 *
 * @property {TaskModel} model
 */
const CreateTaskOwnerConfigView = Marionette.ItemView.extend({

    tagName: 'td',
    className: 'c',

    template: require('./tpl/CreateTaskOwnerConfigView.hbs'),

    options: {
        user: null
    },

    ui: {
        select: 'select',
        remember: '.check',
        popup: '.popup',
        popup_text: '.popup__text'
    },

    events: {
        'change @ui.select': 'onChangedFilter'
    },

    modelEvents: {
        'invalid:owner': 'onValidationError',
        sync: 'onTaskSaved'
    },

    initialize(options) {
        this.options = _.extend({}, this.options, options);

        this.setDefaultUser();
    },

    setDefaultUser() {
        let owner = this.model.get('owner');

        if (!owner) {
            const groups = this.options.user.getGroups().convertToList();

            owner = this.options.user.getPreferences().get('newTaskOwner');

            if (!owner && groups.length === 1) {
                owner = groups[0];
            }

            this.model.set('owner', owner);
        }
    },

    onRender() {
        this.$('.select').bemmySelect();
        this.$('.check').bemmyCheck();
    },

    onChangedFilter() {
        const owner = this.ui.select.val();

        this.ui.popup.removeClass('popup_visible');
        this.model.set('owner', owner);
    },

    onValidationError(err) {
        this.ui.popup_text.text(err.message);
        this.ui.popup.addClass('popup_visible');
    },

    onTaskSaved() {
        const owner = this.model.get('owner');

        if (owner &&
            owner !== this.options.user.get('login') &&
            owner !== 'OTHER' &&
            this.ui.remember.hasClass('checked')) {
            const prefs = this.options.user.getPreferences();

            prefs.set('newTaskOwner', owner);
        }
    },

    serializeData() {
        const owner = this.model.get('owner');
        const groups = this.options.user.isAdmin() ?
            this.options.groups.map(group => {
                return group.get('name');
            }) :
            this.options.user.getGroups().convertToList();

        return {
            owner,
            rememberNewTaskOwner: true,
            user: {
                login: this.options.user.get('login'),
                groups
            }
        };
    }
});

module.exports = CreateTaskOwnerConfigView;
