/**
 * @class CreateTaskSeTagConfigView
 * @extends Marionette.ItemView
 *
 * @property {TaskModel} model
 */
const CreateTaskSeTagConfigView = Marionette.ItemView.extend({

    tagName: 'td',
    className: 'c',

    template: require('./tpl/CreateTaskSeTagConfigView.hbs'),

    options: {
        user: null
    },

    ui: {
        select: 'select'
    },

    events: {
        'change @ui.select': 'onTagSelected'
    },

    modelEvents: {
        sync: 'render'
    },

    onRender() {
        this.$('.select').bemmySelect();
    },

    onTagSelected() {
        const selected = this.ui.select.val();

        this.model.set('se_tag', (selected === '' ? null : selected));
    },

    serializeData() {
        /* eslint camelcase: 0 */

        const selectedTag = this.model.get('se_tag');

        return {
            se_tag: (selectedTag ? selectedTag : ''),
            se_tags: this.model.get('se_tags')
        };
    }
});

module.exports = CreateTaskSeTagConfigView;
