import React from 'react';
import ReactDOM from 'react-dom';

import StatusSelectorView from '../components/statusSelector/StatusSelectorView';
import { SuggestSemaphore } from '../../components/SuggestSemaphore';
import i18n from '../../components/i18n';

/**
 * @class CreateTaskSemaphore
 * @extends Backbone.Marionette.Layout
 */
const CreateTaskSemaphore = Marionette.Layout.extend({

    tagName: 'tr',
    className: 'create_task_list-item',

    template: require('./tpl/CreateTaskSemaphore.hbs'),

    ui: {
        weight: '.semaphore_weight',
        semaphore: '.semaphore_name',
        button: '.transport_selector',
        remover: '.delete_semaphore_group'
    },

    events: {
        'change @ui.weight': 'onWeightChange',
        'click @ui.remover': 'onRemoveGroup'
    },

    initialize(options) {
        this.options = _.extend({}, this.options, options);

        this.onNameChange = this.onNameChange.bind(this);
    },

    initControls() {
        this.$('.input').bemmyInput();
        this.$('.button').bemmyButton();
        this.$('.select').bemmySelect();
        this.$('.check').bemmyCheck();
        this.$('.textarea').bemmyTextarea();
    },

    onRender() {
        this.initControls();

        this.$('.button').bemmyButton();

        this.statusSelector.close();
        this.statusSelector.show(new StatusSelectorView({
            model: this.model,
            statusField: 'release'
        }));

        if (this.ui.semaphore[0]) {
            ReactDOM.render(
                <SuggestSemaphore
                    value={this.model.get('name')}
                    name={'name'}
                    placeholder={i18n.labels.semaphore.name}
                    onChange={this.onNameChange} // eslint-disable-line
                    />,
                this.ui.semaphore[0]
            );
        }
    },

    onRemoveGroup() {
        this.model.collection.remove(this.model);
    },

    onNameChange(e) {
        if (this.model.get('name') !== e.target.value) {
            this.model.set('name', e.target.value);
        }
    },

    onWeightChange(evtObj) {
        this.model.set(
            'weight',
            (isNaN(Number(evtObj.target.value)) || Number(evtObj.target.value) < 0) ?
                0 :
                Number(evtObj.target.value)
        );

        this.render();
    }
});

module.exports = CreateTaskSemaphore;
