const SemaphoreModel = require('../../model/TaskRequirementsSemaphoresModel');
const CreateTaskSemaphore = require('./CreateTaskSemaphore');

/**
 * @class CreateTaskSemaphoresConfigView
 * @extends Backbone.Marionette.ItemView
 */
const CreateTaskSemaphoresConfigView = Marionette.Layout.extend({

    className: 'c gap_XS section__list',

    template: require('./tpl/CreateTaskSemaphoresConfigView.hbs'),

    ui: {
        addTrigger: '.add_semaphore'
    },

    events: {
        'click @ui.addTrigger': 'onAddSemaphore'
    },

    initialize(options) {
        this.options = _.extend({}, this.options, options);
    },

    onRender() {
        this.showSemaphores();
    },

    onAddSemaphore() {
        this.collection.add(new SemaphoreModel({}));
    },

    showSemaphores() {
        this.semaphores.close();
        this.semaphores.show(new Marionette.CollectionView({
            tagName: 'tbody',
            collection: this.collection,
            itemView: CreateTaskSemaphore,
            itemViewOptions: {
                taskProps: this.options.taskProps
            }
        }));
    }
});

module.exports = CreateTaskSemaphoresConfigView;
