// eslint-disable-next-line no-unused-vars
const app = require('../../app');
const error = require('../../error');
const router = require('../../router');
const TaskModel = require('../../model/TaskModel');
const BasicConfirmDialogViewWithUserType = require('../components/BasicConfirmDialogViewWithUserType');
const TaskTypeAutocompleteView = require('../controlSection/filter/selects/autocomplete/TaskTypeAutocompleteView');

/**
 * @class CreateTaskTypeSelectPopupView
 * @extends BasicConfirmDialogViewWithUserType
 */
const CreateTaskTypeSelectPopupView = BasicConfirmDialogViewWithUserType.extend({

    template: require('./tpl/CreateTaskTypeSelectPopupView.hbs'),

    options: _.extend({}, BasicConfirmDialogViewWithUserType.prototype.options, {
        btnDisableClass: 'button_disable',
        typeSelectorInputClass: 'new_task_type',
        typeSelectorPlaceholder: 'Select type for a new task'
    }),

    ui: _.extend({}, BasicConfirmDialogViewWithUserType.prototype.ui, {
        approveBtn: '.app_modal_approve',
        spinner: '.type-selector-controls .spinner',
        type: '.new_task_type'
    }),

    events: _.extend({}, BasicConfirmDialogViewWithUserType.prototype.events, {
        'change @ui.type': 'onChangeType'
    }),

    initialize(options) {
        this.model = TaskModel.createBlankTask();
        this.options = _.extend({}, this.options, options);

        BasicConfirmDialogViewWithUserType.prototype.initialize.apply(this, arguments);
    },

    onRender() {
        this.typeSelector.close();
        this.typeSelector.show(this.getTypeSelector());
        this.ui.type = this.$el.find('.new_task_type');

        // This.focusOnInnerInput();
    },

    onChangeType(needTrigger) {
        const type = this.ui.type.val();
        let action = true;

        if ($.trim(type) !== '') {
            this.setModelType(type);
            action = false;
        }

        this.ui.approveBtn.toggleClass(this.options.btnDisableClass, action);

        if (needTrigger === 'trigger') {
            this.ui.approveBtn.click();
        }
    },

    onApprove() {
        const self = this;

        if (this.model.get('type') !== '') {
            this.model.attributes = {
                type: this.model.get('type'),
                author: this.options.user.get('login')
            };

            this.ui.spinner.removeClass('hidden');

            this.model.save().done(response => {
                self.model.set(TaskModel.prototype.parse.call(self.model, response));

                self.updateUserTypeList.bind(self)('userTaskTypesList', self.model.get('type'), () => {
                    self.loadTaskPage();
                });
            }).fail((err, name, description) => {
                this.ui.spinner.addClass('hidden');
                error.fromXHR({ xhr: err, name, description }, { autoClose: true });
            });
        }
    },

    setModelType(type) {
        this.model.set('type', type);
    },

    loadTaskPage() {
        this.close();
        router.navigate('/task/' + this.model.get('id') + '/view', { trigger: true });
    },

    getTypeSelector() {
        return new TaskTypeAutocompleteView({
            model: this.model,
            items: this.options.types,
            value: '',
            placeHolder: this.options.typeSelectorPlaceholder,
            selectClassName: this.options.typeSelectorInputClass
        });
    },

    serializeData() {
        return {
            userTypeList: this.getUserTypeList('userTaskTypesList')
        };
    }
});

module.exports = CreateTaskTypeSelectPopupView;
