const CustomFieldView = require('./CustomFieldView');

const BooleanCustomFieldView = CustomFieldView.extend({

    template: require('./tpl/edit/BooleanCustomFieldView.hbs'),

    ui: _.extend({}, CustomFieldView.prototype.ui, {
        input: '.check',
        popup: '.popup',
        popupOverlay: '.popup-overlay'
    }),

    events: {
        'bemmy:set @ui.input': 'onChange'
    },

    initialize() {
        if (this.options.fieldViewMode === CustomFieldView.MODE.VIEW) {
            this.template = require('./tpl/view/BooleanCustomFieldView.hbs');
        }

        CustomFieldView.prototype.initialize.apply(this, arguments);
    },

    onRender() {
        this.ui.input.bemmyCheck();
        this.ui.popupOverlay.bemmyPopupOverlay();

        CustomFieldView.prototype.onRender.apply(this, arguments);
    },

    onChange(evtObj, value) {
        this.onValueChanged(value);
    }

});

module.exports = BooleanCustomFieldView;
