const AuthorSuggestView = require('../../controlSection/filter/suggest/AuthorSuggestView');
const CreateTaskCustomListView = require('./CreateTaskCustomListView');

/**
 * @class CreateTaskNotification
 * @extends Backbone.Marionette.Layout
 */
module.exports = CreateTaskCustomListView.extend({
    template: require('./tpl/edit/StaffCustomListView.hbs'),

    onRender() {
        this.ui.remover.bemmyButton();
        this.ui.input.bemmyInput();
        this.ui.inputVal.bemmyInput();
        this.ui.select.bemmySelect();
        this.ui.popupOverlay.bemmyPopupOverlay();

        this.addRegions({ authorSuggest: '#authorSuggest' });

        if (this.model.get('modifiers').repetition === 'list') {
            this.authorSuggest.close();
            this.authorSuggest.show(new AuthorSuggestView({
                model: this.model,
                defaultValue: this.model.get('value'),
                modelTargetKey: 'value',
                placeholder: ''
            }));
        } else {
            this.authorSuggest.close();
            this.authorSuggest.show(new AuthorSuggestView({
                model: this.model,
                defaultValue: this.model.get('contextValue'),
                modelTargetKey: 'contextValue',
                placeholder: ''
            }));
        }
    }
});
