// eslint-disable-next-line no-unused-vars
const CustomFieldView = require('./CustomFieldView');

/**
 * @class CreateTaskNotification
 * @extends Backbone.Marionette.Layout
 */
module.exports = Marionette.Layout.extend({

    tagName: 'tr',
    className: 'create_task_list-item',

    template: require('./tpl/edit/StringCustomListView.hbs'),

    ui: {
        input: '.input_type_key',
        inputVal: '.input_type_val',
        trueInput: '.input_type_key .input__input',
        trueValueInput: '.input_type_val .input__input',
        select: '.select',
        trueSelect: '.select select',
        remover: '.delete_item_group',
        popup: '.popup',
        popupOverlay: '.popup-overlay'
    },

    events: {
        'click @ui.remover': 'onRemoveGroup',
        'blur @ui.trueInput': 'onChangeKey',
        'blur @ui.trueValueInput': 'onChangeValue',
        'change @ui.select': 'onChangeValue'
    },

    options: {
        form: false
    },

    initialize(options) {
        this.options = _.extend({}, this.options, options);
    },

    onRender() {
        this.ui.remover.bemmyButton();
        this.ui.input.bemmyInput();
        this.ui.inputVal.bemmyInput();
        this.ui.select.bemmySelect();
        this.ui.popupOverlay.bemmyPopupOverlay();
    },

    onChangeKey(evtObj) {
        this.model.set('value', evtObj.target.value);
    },

    onChangeValue(evtObj) {
        this.model.set('contextValue', evtObj.target.value);
    },

    onRemoveGroup() {
        this.model.collection.remove(this.model);
    },

    serializeData() {
        /* eslint complexity: [1, 9] */

        const context = this.model.get('context') || {};
        const initialOpts = [];

        if (this.model.get('context') && this.model.get('context').values && !this._isBlankValueExists()) {
            initialOpts.push({ title: 'Any', value: '' });
        }

        const serialized = _.reduce(context.values, (result, item) => {
            result.push({
                title: item[0] || 'Any',
                value: item[1]
            });

            return result;
        }, initialOpts);

        return {
            context: {
                values: serialized,
                value: this.model.get('contextValue') || ''
            },
            value: this.model.get('value') || '',
            type: this.model.get('fieldType') || '',
            description: this.model.get('description') || ''
        };
    },

    /**
     * Проверяем включает ли контекст пустое значение
     * @returns boolean флаг
     * @private
     */
    _isBlankValueExists() {
        const context = this.model.get('context');
        const contextValues = context.values;

        return contextValues && contextValues.reduce((result, value) => {
            return result || value[1] === '';
        }, false);
    }
});
