/* eslint react/jsx-handler-names: [0] */

import React from 'react';
import ReactDOM from 'react-dom';

import CustomFieldView from './CustomFieldView';

import AceEditor from 'react-ace';
import clipboardClientMixin from '../../components/clipboardClient/ClipboardClientMixin';

import 'brace/mode/json';
import 'brace/mode/yaml';
import 'brace/theme/tomorrow';

const FormattedCustomFieldView = CustomFieldView.extend({

    template: require('./tpl/edit/FormattedCustomFieldView.hbs'),

    ui: _.extend({}, CustomFieldView.prototype.ui, {
        ace: '.ace',
        popup: '.popup',
        popupOverlay: '.popup-overlay'
    }),

    initialize() {
        CustomFieldView.prototype.initialize.apply(this, arguments);

        if (this.options.fieldViewMode === CustomFieldView.MODE.VIEW) {
            this.template = require('./tpl/view/FormattedCustomFieldView.hbs');
        }

        this.onChange = this.onChange.bind(this);
        this.onValidate = this.onValidate.bind(this);
    },

    parseValue() {
        if (!this.model.get('value')) {
            return '';
        }

        return JSON.stringify(this.model.get('value'), null, 4);
    },

    getFormat() {
        return ((this.model.get('modifiers') || {}).format || 'json').toLowerCase();
    },

    onRender() {
        /* eslint react/forbid-component-props: 0 */

        clipboardClientMixin.initializeClipboardClient(
            '.json-data-copier',
            'JSON data has been copied to clipboard.'
        );

        CustomFieldView.prototype.onToggle.call(this, this.options.isVisible);

        const isReadOnly = this.options.fieldViewMode === CustomFieldView.MODE.VIEW;

        if (this.ui.ace[0]) {
            ReactDOM.render(
                <AceEditor
                    className={isReadOnly ? 'disabled' : ''}
                    mode={this.getFormat()}
                    theme="tomorrow"
                    height="200px"
                    width={isReadOnly ? '100%' : '660px'}
                    minLines={3}
                    maxLines={Infinity}
                    debounceChangePeriod={400}
                    onChange={this.onChange}
                    onValidate={this.onValidate}
                    fontSize={13}
                    showPrintMargin
                    showGutter
                    wrapEnabled={false}
                    highlightActiveLine={false}
                    value={this.parseValue()}
                    readOnly={isReadOnly}
                    setOptions={{
                        readOnly: isReadOnly,
                        highlightActiveLine: false,
                        highlightGutterLine: false,
                        enableBasicAutocompletion: true,
                        enableSnippets: false,
                        showLineNumbers: false,
                        cursorStyle: 'none',
                        tabSize: 4
                    }}
                    style={{
                        border: '1px solid rgba(0, 0, 0, 0.2)'
                    }}
                    />,
                this.ui.ace[0]
            );
        }

        this.ui.popupOverlay.bemmyPopupOverlay();
    },

    onChange(newValue) {
        if (this.getFormat() === 'json' && newValue !== '') {
            try {
                this.model.set('value', eval('('+ newValue + ')')); // eslint-disable-line
            } catch (e) { /* NOOP */ }
        } else {
            this.model.set('value', newValue);
        }
    },

    onValidate(errors) {
        if (errors.length) {
            this.model.set('hasError', { format: this.getFormat() });
        } else {
            this.model.set('hasError', false);

            this.ui.popup.removeClass('popup_visible');
        }
    }
});

module.exports = FormattedCustomFieldView;
